
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL
{
    internal class AdvancedLevel : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.AdvancedLevel, BO.AdvancedLevel>
    {

        internal AdvancedLevel(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal AdvancedLevel(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.AdvancedLevel.DBD) { }

        internal BO.AdvancedLevel RestoreTopOne(BO.AdvancedLevel.Search Search)
        {
            return InternalRestoreOne((int)DBD.AdvancedLevel.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["PointPercent"].Value = Search.PointPercent;
                Command["ChangePointPercent"].Value = Search.ChangePointPercent;
                Command["Weight"].Value = Search.Weight;
            });
        }

        internal List<BO.AdvancedLevel> Restore(BO.AdvancedLevel.Search Search)
        {
            return InternalRestoreList((int)DBD.AdvancedLevel.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["PointPercent"].Value = Search.PointPercent;
                Command["ChangePointPercent"].Value = Search.ChangePointPercent;
                Command["Weight"].Value = Search.Weight;
            });
        }
    }
}
